﻿''' <summary>
'''  简单的工具/选项窗体，使用户能够更改应用程序采用的字体、前景色和背景色。
''' </summary>
Public Class UserOptionsForm

    Private m_newFont As Font
    Private m_newBackColor As Color
    Private m_newForeColor As Color

    Public Sub New()
        ' 此调用是 Windows 窗体设计器所必需的。
        InitializeComponent()
        InitializeSettings()
        ResetControlValues()
    End Sub

    ' 本应能够对其应用双向数据绑定，但似乎在此内部版本中不起作用...
    Private Sub ResetControlValues()

        Me.FontNameTextBox.Text = m_newFont.Name & ", " & m_newFont.SizeInPoints
        Me.ForeColorLabel.BackColor = m_newForeColor
        Me.BackColorLabel.BackColor = m_newBackColor

        '更新文本框的预览
        Me.OptionsPreviewTextBox.ForeColor = m_newForeColor
        Me.OptionsPreviewTextBox.BackColor = m_newBackColor
        Me.OptionsPreviewTextBox.Font = m_newFont
    End Sub


    ''' <summary>
    ''' 如果所选颜色已经改变，则更新此控件
    ''' </summary>
    Private Sub FontSelectButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FontSelectButton.Click
        Dim fontDialog As New FontDialog()
        fontDialog.Font = m_newFont
        If (fontDialog.ShowDialog() = Windows.Forms.DialogResult.OK) Then
            m_newFont = fontDialog.Font
            ResetControlValues()
        End If
    End Sub

    ''' <summary>
    ''' 如果用户选择 OK 按钮，则用新设置值更新 My.Settings
    ''' </summary>
    Private Sub Ok_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Ok_Button.Click
        With My.Settings
            .BackColor = m_newBackColor
            .Font = m_newFont
            .ForeColor = m_newForeColor
        End With
        Me.Close()
    End Sub

    ''' <summary>
    ''' 不保存设置更改。
    ''' </summary>
    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel_Button.Click
        Me.Close()
    End Sub

    ''' <summary>
    ''' 更新背景色
    ''' </summary>
    Private Sub SelectBackColorButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SelectBackColorButton.Click
        Dim colorPicker As New ColorDialog()
        colorPicker.Color = Me.m_newBackColor
        If (colorPicker.ShowDialog() = Windows.Forms.DialogResult.OK) Then
            m_newBackColor = colorPicker.Color
            ResetControlValues()
        End If
    End Sub

    ''' <summary>
    ''' 更新前景色
    ''' </summary>
    Private Sub SelectForeGroundColorButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SelectForeGroundColorButton.Click
        Dim colorPicker As New ColorDialog()
        colorPicker.Color = Me.m_newForeColor
        If (colorPicker.ShowDialog() = Windows.Forms.DialogResult.OK) Then
            m_newForeColor = colorPicker.Color
            ResetControlValues()
        End If

    End Sub

    Private Sub InitializeSettings()
        m_newFont = My.Settings.Font
        m_newBackColor = My.Settings.BackColor
        m_newForeColor = My.Settings.ForeColor
    End Sub
End Class
